CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns     
                    WHERE table_name= 'est_prod_cpl' 
                         and column_name='perc_fecop_st') THEN
                         
        RAISE NOTICE 'Coluna "perc_fecop_st" na tabela "est_prod_cpl" ja existe!' ;
        
    ELSE
        ALTER TABLE public.est_prod_cpl ADD COLUMN perc_fecop_st numeric(14,2) default 0.0;     
        RAISE NOTICE 'Coluna "perc_fecop_st" criada com sucesso!';
    END IF; 
    
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();